#!/usr/bin/env sh -l

# main.command
# Add Aux Info to PDF

#  Created by ???? on 06/08/12.
#  Copyright 2006 __MyCompanyName__. All rights reserved.

# Type of input and output needs com.apple.cocoa.path. Isn't that com.apple.applescript.alias-object.pdf?
# When I set it, the script didn't execute at all.

LOGFILE=~/Library/Logs/pdfauxinfo.log
OUTFILE=`mktemp -t pdfauxinfo`
INFILE=`cat`

case "$userpassword" in
	"")		u=
			up=
			;;
	*)		u="--userPassword"
			up=$userpassword
			;;
esac
case "$ownerpassword" in
	"")		o=
			op=
			;;
	*)		o="--ownerPassword"
			op=$ownerpassword
			;;
esac
case "$author" in
	"")		a=
			ap=
			;;
	*)		a="--author"
			ap=$author
			;;
esac
case "$title" in
	"")		t=
			tp=
			;;
	*)		t="--title"
			tp=$title
			;;
esac
case "$creator" in
	"")		k=
			kp=
			;;
	*)		k="--creator"
			kp="$creator"
			;;
esac
case "$permitcopying" in
	"")		c=;;
	-1)	c="--permitCopying NO " ;;
	1)	c="--permitCopying YES " ;;
esac
case "$permitprinting" in
	"")		p=;;
	-1)	p="--permitPrinting NO " ;;
	1)	p="--permitPrinting YES " ;;
esac

/usr/sbin/pdfauxinfo --sourcePDFFile "${INFILE}" --convertedPDFFile ${OUTFILE}.pdf $u "$up" $o "$op" $a "$ap" $t "$tp" $k "$kp" $c $p

# Logging

DATESTR=`date "+%m/%d %H:%M:%S"`
echo -n ${DATESTR} >> $LOGFILE
echo -n "　/usr/sbin/pdfauxinfo --sourcePDFFile \"${INFILE}\" --convertedPDFFile ${OUTFILE}.pdf " >> $LOGFILE
echo "$u \"$up\" $o \"$op\" $a \"$ap\" $t \"$tp\" $k \"$kp\" $c $p" >> $LOGFILE

echo "${OUTFILE}.pdf"

exit 0